<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRatesTable extends Migration
{
    public function up()
    {
        Schema::create('rates', function (Blueprint $table) {
            $table->bigIncrements('rate_id');
            $table->bigInteger('profile_id')->unsigned()->notNullable();
            $table->decimal('hourly_min', 10, 2)->notNullable();
            $table->decimal('hourly_max', 10, 2)->notNullable();
            $table->bigInteger('currency_id')->unsigned()->notNullable();
            $table->tinyInteger('is_negotiable')->default(1);
            $table->longText('factors')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->foreign('profile_id')->references('Profile_id')->on('candidate_profiles')->onDelete('cascade');
            $table->foreign('currency_id')->references('Currency_id')->on('currencies')->onDelete('restrict');
        });
    }

    public function down()
    {
        Schema::dropIfExists('rates');
    }
}
